import numpy as np

def linfit(x, y):
    """Linear regression y = a*x + b with R^2."""
    x = np.asarray(x, dtype=float)
    y = np.asarray(y, dtype=float)
    if x.size == 0 or y.size == 0:
        return 0.0, 0.0, 0.0
    if np.allclose(x, x[0]) or np.allclose(y, y[0]):
        a = 0.0
        b = float(y.mean()) if len(y) else 0.0
        r2 = 0.0
        return float(a), float(b), float(r2)
    A = np.vstack([x, np.ones_like(x)]).T
    a, b = np.linalg.lstsq(A, y, rcond=None)[0]
    yhat = a*x + b
    ss_res = np.sum((y - yhat)**2)
    ss_tot = np.sum((y - y.mean())**2)
    r2 = 1.0 - ss_res/ss_tot if ss_tot > 0 else 0.0
    return float(a), float(b), float(r2)
